{Erweiterung des Programms}
{-Ordnen der erzeugten Datei in alphabetischer Reihenfolge}
{-Datei bearbeiten knnen, d.h. Hinzufgen oder ndern von Wortdef.}
{-erzeugtes Rtsel als Textdatei speichern oder Rtsel ausdrucken}
{-Rtsel verndern}
{-Beschleunigung des Programms}

program verskreuz;
uses dos,crt,objects,app,menus,dialogs,drivers,views,stddlg;
{-----------------------------------------------------------------------}
const maxzeilenlesen = 60;
      maxwortlesen = 3000;
      maxworte=300;
      maxbuchst=5;

{-----------------------------------------------------------------------}
type acrdow = array[1..5, 1..5] of char;
     kreuztyp = array[1..6] of acrdow;
type maxbuchstwort = string[5];
       string30 = string[30];
type pwort = ^wort;
       wort = record
                krwort:maxbuchstwort;
                bedeut:string30
              end;
     krdattyp = record
                  krwort:maxbuchstwort;
                  bedeut:string30
                end;

{-----------------------------------------------------------------------}

var l,m,o,p:integer; {Zhlervariable von kreuz}
{-----------------------------------------------------------------------}
const
  cmdaterzeugen     =100;
  cmdatladen     =101;
  cmdatbearbeiten   =102;
  cmkreuz      =103;
  cmkreuzbearbeiten   =104;
  cminfo      =105;
  cmhelp      =106;
  cm0         =107;
  cmallefenstweg=108;
{-----------------------------------------------------------------------}
type pkrapp = ^krapp;
     krapp = object(tapplication)
     kreuznr: byte;
     dateiname: pathstr;
     ausgbox: array[1..6] of pdialog;
     boxweg: boolean;
     kreuzspeicher: kreuztyp;
     datname,textdatname: pathstr;
     textdatei: text;
     kreuzdatei: file of krdattyp;
     tworte: array [1..maxworte] of pwort;
     constructor init;
     destructor done; virtual;
     procedure initmenubar; virtual;
     procedure initstatusline; virtual;
     procedure handleevent(var event: tevent); virtual;
     procedure idle; virtual;
     procedure daterzeugen;
     procedure datladen;
     procedure datbearbeiten;
     procedure kreuz;
     procedure kreuzbearbeiten;
     procedure info;
     procedure help;
     procedure fensterweg;
     procedure datoffen;
     end;

{-----------------------------------------------------------------------}
constructor krapp.init;
  begin
    dateiname:='';
    textdatname:='';
    kreuznr:=1;    
    tapplication.init;
    info
  end;

destructor krapp.done;
  begin
    tapplication.done
  end;

procedure krapp.initmenubar;
  const
    nomenu: pmenu = nil;
    noitem: pmenuitem = nil;
  var r: trect;
  begin
    getextent(r);
    R.B.Y := R.A.Y+1;
    menubar:= new(pmenubar, init(r, newmenu(
    newsubmenu('~b~eenden',0,newmenu(
      newitem('~J~a','Alt-X',kbaltx, cmquit,0,
      newitem('~N~ein', '', kbnokey, cmcancel, 0,
     noitem
    ))),
    newsubmenu('~D~atei', 0, newmenu(
      newitem('Datei ~l~aden','F2',kbF2, cmdatladen, 0,
      newitem('Datei er~z~eugen','F3', kbF3, cmdaterzeugen, 0,
    noitem
    ))),
    newsubmenu('~K~reuzwortrtsel', 0, newmenu (
      newitem('neues K~r~euzwortrtsel', 'F5', kbF5, cmkreuz, 0,
      newitem('alle Kreuzwortrtsel lschen','',kbnokey,cmallefenstweg,0,
    noitem
    ))),
    newsubmenu('~H~ilfe', 0, newmenu (
      newitem('~H~ilfetext', 'F1', kbF1, cmhelp, 0,
      newitem('ber Kreuz', '', kbnokey, cminfo, 0,
    noitem
    ))),
    noitem
    )))))))
  end;
{-----------------------------------------------------------------------}
  procedure krapp.initstatusline;
    var r:trect;
    begin
      getextent (r);
      r.a.y := r.b.y - 1;
      statusline := new (pstatusline,init (r,
             newstatusdef (0,$FFFF,
               newstatuskey ('                             ',kbnokey,cm0,
               newstatuskey ('*** ~KREUZ~ ***',kbnokey,cminfo,
               nil)),nil)))
    end;
{-----------------------------------------------------------------------}
{Hier wird eine Textdatei  geffnet}
{-----------------------------------------------------------------------}
    procedure krapp.datoffen;
  var fehler: integer;
      fehlerbox: pdialog;
      c:word;
      r:trect;
      t:pstatictext;
  begin
    {$I-}
    assign(textdatei,textdatname);
    reset(textdatei);
    {$I+}
    fehler:=ioresult;
    if fehler <> 0 then begin
       r.assign (15,8,61,13);
       fehlerbox:= new (pdialog,init (r,'Achtung!'));
       r.assign (1,2,45,3);
        fehlerbox^.insert (new (pstatictext,init (r,
             'Datei nicht geffnet. Fehler!'
             )));
          desktop^.insert (fehlerbox);
          delay(3000);
         dispose(fehlerbox,done)
      end
  end;
{-------------------------------------------------------------------}
{Hier wird aus einer Textdatei(ASCII) eine Datei *.kr erzeugt}
{-------------------------------------------------------------------}

  procedure krapp.daterzeugen;
  procedure benennen;
    var
      i:pinputline;
      a:pdialog;
      r:trect;
      c:word;

    begin
      repeat
      r.assign (20,8,56,15);
      new (a,init (r,'Wie soll die Datei heien?'));

      r.assign (3,4,11,6);
      a^.insert (new (pbutton,init (r,'~O~k',cmok,bfdefault)));

      r.assign (19,4,32,6);
      a^.insert (new(pbutton,init (r,'~Abbruch',cmcancel,bfnormal)));

      r.assign (12,2,22,3);
      a^.insert (new (pinputline,init (r,8)));
      a^.setdata (datname);

      c:=desktop^.execview (a);
      a^.getdata (datname);
      dispose (a,done);
      until (datname <> '') or (c = cmcancel);
      datname:=datname + '.kr'
    end;

  procedure auswahl;
    var d: pfiledialog;
    begin
      d:=new (pfiledialog,
        init ('*.txt','Welche Textdatei wollen Sie laden?',
              '~N~ame',fdopenbutton,100));
      if desktop^.execview (d) <> cmcancel then
         d^.getfilename (textdatname);
      dispose (d,done)
    end;


  procedure worteinlesen;
 var  j,n: integer;
      wpuffer:string;
      zpuffer:string;
      zeichen:char;
  begin
    m:=0;
    repeat
      zpuffer:='';
      readln(textdatei,zpuffer);
      o:=0;
      repeat
        wpuffer:='';
        repeat
          inc(o);
          zeichen:=zpuffer[o];
          if zeichen in ['A'..'Z','a'..'z']
            then wpuffer:=wpuffer + upcase(zeichen);
        until (zeichen=chr(32)) or (o=length(zpuffer))
              or (m=maxworte) or (length(zpuffer)=0);
        if (length(wpuffer) <=  maxbuchst) and
           (length(wpuffer) <> 0) then begin
            inc(m);
            tworte[m]:=nil;
            new(tworte[m]);
            tworte[m]^.krwort:='     ';
            tworte[m]^.krwort:=wpuffer
          end;
      until (o=length(zpuffer)) or (m=maxworte) or (length(zpuffer)=0);
    until (eof(textdatei)) or (m=maxworte);
    close(textdatei)
  end;

  procedure ordnen;
  begin
    {Wrter, die mehrmals vorkommen, werden aussortiert}
    for o:=1 to m do begin
      for l:=o+1 to m do begin
        if tworte[o]^.krwort=tworte[l]^.krwort then tworte[l]^.krwort:='     '
      end
    end;
    for l:=1 to m do begin
      if tworte[l]^.krwort='     ' then begin
        for o:=l to (m-1) do tworte[o]^.krwort:=tworte[o+1]^.krwort
      end
    end
  end;

  procedure ordnenpointer;
    begin
    for l:=1 to (m-1) do begin
      if tworte[l]^.krwort='     ' then begin
        for o:=l to m do dispose(tworte[o]);
        m:=l
      end
    end
  end;

  {Datei wird gespeichert}
  procedure speichern;
  var
    datwort: krdattyp;
  begin
    assign(kreuzdatei,datname);
    {$I-}
    reset(kreuzdatei);
        {$I+}
        if IORESULT <> 0
          then rewrite(kreuzdatei)
          else begin
            writeln('Fehler: die Datei existiert schon!');
            delay(2000)
          end;
        {$I-}
    for l:=1 to m do begin
      datwort.krwort:='     ';
      datwort.bedeut:='                              ';
      datwort.krwort:=tworte[l]^.krwort;
      write(kreuzdatei,datwort)
      end;
    close(kreuzdatei)
  end;

    begin
      benennen;
      auswahl;
      if textdatname <> '' then begin
        datoffen;
        worteinlesen;
        ordnen;
        ordnen;
        ordnen;
        ordnenpointer;
        speichern;
        for l:=1 to (m-1) do dispose(tworte[l]);
        datname:='';
        textdatname:=''
      end
    end;

{-----------------------------------------------------------------------}
{      Hier wird die zu verarbeitende Datei geladen                     }
{-----------------------------------------------------------------------}
  procedure krapp.datladen;
    var d: pfiledialog;
    begin
      d:=new (pfiledialog,
        init ('*.kr','Welche Datei wollen Sie laden?',
              '~N~ame',fdopenbutton,100));
      if desktop^.execview (d) <> cmcancel then
         d^.getfilename (dateiname);
      dispose (d,done)
    end;

{-----------------------------------------------------------------------}
{Hier soll wie o.g. eine Datei *.kr bearbeitet werden}
{-----------------------------------------------------------------------}
  procedure krapp.datbearbeiten;
    begin
    end;
{-----------------------------------------------------------------------}
{Verteilung von Wrtern im Kreuzwortrtsel mit Hilfe der Datei *.kr}
{-----------------------------------------------------------------------}

  procedure krapp.kreuz;


type worttyp=string[20];
     pufferworttyp  =array[1..maxworte] of worttyp;
     wortdateityp = file of krdattyp;
     texttyp = string[79];
     feldtyp = array[1..5, 1..5] of char;
     richttyp = record
                  word: worttyp;
                  waag: boolean;
                  nr:byte;
                  end;
     eintragtyp = array[1..15] of richttyp;

var wortpuffer: pufferworttyp;
    wortdatei: wortdateityp;
    feld: feldtyp;
    dateigr, zzahl:longint;
    wort: worttyp;
    eintrag:eintragtyp;
    wartbox: pdialog;
    c:word;
    r:trect;
    t:pstatictext;
    speicherbelegung:integer;
    procedure uebergab;
      var a,b:byte;
      begin
        for a:=1 to 5 do begin
          for b:=1 to 5 do kreuzspeicher[kreuznr,a,b]:=feld[a,b]
        end
      end;

procedure schreibln(text:texttyp;zeile,spalte:byte);
  begin
    gotoxy(spalte, zeile);
    writeln(text)
  end;

procedure oeffnen;
  var wort:krdattyp;
  begin
    {$I+}
    assign(wortdatei,dateiname);
    reset(wortdatei);
      if IORESULT <> 0
        then begin
          schreibln('Datei existiert nicht!',1,1); delay(1000)
          end;
    {$I-}
    m:=0;
    repeat
        inc(m);
        wort.krwort:='     ';
        wort.bedeut:='                              ';
        read(wortdatei,wort);
        wortpuffer[m]:=wort.krwort;
    until (eof(wortdatei)) or (m=maxworte);
    dateigr:=filesize(wortdatei);
    close(wortdatei);
    speicherbelegung:=m
  end;

procedure einsetzen;

  procedure zufall(lang: byte);
    var zahl: integer;
    begin
      repeat
        randomize;
        for l:=1 to dateigr do zahl:=random(dateigr);
      until length(wortpuffer[zahl]) < lang;
      zzahl:=zahl
    end;

  function wortlaengezu: byte;
    begin
      wortlaengezu:=length(wortpuffer[zzahl])
    end;

  function wortlaenge: byte;
    begin
      wortlaenge:=length(wort)
    end;

  function zuwort(wortlang: byte):worttyp;
    var pwort: worttyp;
    begin
      repeat
        zufall(wortlang);
        pwort:=wortpuffer[zzahl];
      until length(pwort) in [2..wortlang];
      zuwort:=pwort
    end;

  procedure worduebergabe(unr:byte; uwaag:boolean);
    begin
      eintrag[unr].word:=wort;
      eintrag[unr].waag:=uwaag;
      eintrag[unr].nr:=unr
    end;

  procedure wortplus1(lange:byte);
    begin
      l:=0;
      repeat
        inc(l);
        wort:=wortpuffer[l];
      until (wortlaenge=lange) or (l=maxworte);
      m:=0;
      for l:=6-lange to 5 do begin
        inc(m);
        feld[1,l]:=wort[m];
        worduebergabe(2,true)
        end
    end;

  procedure suchewort(a,b,c,d,e:char; leng:byte);
    var prwort: worttyp;
        agef, bgef, cgef, dgef, egef: boolean;
        sm: integer;
    begin
      sm:=0;
      repeat
        repeat
          inc(sm);
          prwort:=wortpuffer[sm]
        until (length(prwort) =leng) or (sm=speicherbelegung);
        if (a=prwort[1]) or (a=' ')
          then agef:=true
          else agef:=false;
        if (b=prwort[2]) or (b=' ')
          then bgef:=true
          else bgef:=false;
        if (c=prwort[3]) or (c=' ')
          then cgef:=true
          else cgef:= false;
        if (d=prwort[4]) or (d=' ')
          then dgef:=true
          else dgef:=false;
        if (e=prwort[5]) or (e=' ')
          then egef:=true
          else egef:=false
      until (sm=speicherbelegung) or ((agef=true) and (bgef=true) and 
            (cgef=true) and (dgef=true) and (egef=true));
      if sm=speicherbelegung then wort:=''           {kein Wort gefunden}
        else wort:=prwort
    end;

procedure eins;
  begin
    wort:='';
    repeat
      wort:=zuwort(6);
    until wortlaenge=5;
    for l := 1 to wortlaenge do feld[1,l]:=wort[l];
    worduebergabe(1,true)
  end;

procedure zwei;
  begin
    suchewort(feld[1,5],' ',' ',' ',' ',5);
    if wort=''then begin
      repeat
        wort:=zuwort(5);
      until wortlaenge=4;
      for l:=2 to (wortlaenge+1) do feld[l,5]:=wort[l-1]
      end
     else for l:=1 to wortlaenge do feld[l,5]:=wort[l];
    worduebergabe(2,false)
  end;

procedure drei;
  begin
    suchewort(' ',' ',' ',' ',feld[2,5],5);
    if wort='' then begin
      repeat
        wort:=zuwort(5);
      until wortlaenge=4;
      for l:=1 to wortlaenge do feld[2,l]:=wort[l]
      end
     else for l:=1 to wortlaenge do feld[2,l]:=wort[l];
    worduebergabe(3,true)
  end;

procedure vier;
  begin
    suchewort(feld[1,4],feld[2,4],' ',' ',' ',5);
    if wort='' then begin
      suchewort(feld[2,4],' ',' ',' ',' ',4);
      if wort<>'' then for l:=2 to (wortlaenge+1) do feld[l,4]:=wort[l-1]
        else begin
        repeat
          wort:=zuwort(4)
        until wortlaenge=3;
        for l:=3 to (wortlaenge+2) do feld[l,4]:=wort[l-2]
        end
      end
    else for l:=1 to wortlaenge do feld[l,4]:=wort[l];
    worduebergabe(4,false)
  end;

procedure funf;
  begin
    suchewort(' ',' ',' ',feld[3,4],feld[3,5],5);
    if wort='' then begin
      suchewort(' ',' ',' ',feld[3,4],' ',4);
      if wort<>'' then for l:=1 to wortlaenge do feld[3,l]:=wort[l]
       else begin
        repeat
          if feld[3,4]=' ' then begin
            repeat
              wort:=zuwort(5)
            until wortlaenge=4
            end
           else begin
            repeat
              wort:=zuwort(4);
            until wortlaenge=3
            end;
        until wort<>eintrag[4].word;
        for l:=1 to wortlaenge do feld[3,l]:=wort[l]
        end
      end
    else for l:=1 to wortlaenge do feld[3,l]:=wort[l];
    worduebergabe(5,true)
  end;

procedure sechssiebenacht(za:byte);
  var zl: byte;
  begin
    zl:=za;
    suchewort(feld[1,zl],feld[2,zl],feld[3,zl],' ',' ',5);
    if wort='' then begin
      suchewort(feld[2,zl],feld[3,zl],' ',' ',' ',4);
      if wort='' then begin
        suchewort(feld[3,zl],' ',' ',' ',' ',3);
        if wort='' then begin
          suchewort(' ',' ',' ',' ',' ',2);
          for l:=4 to (wortlaenge+3) do feld[l,zl]:=wort[l-3]
          end
         else for l:=3 to (wortlaenge+2) do feld[l,zl]:=wort[l-2]
        end
       else for l:=2 to (wortlaenge+1) do feld[l,zl]:=wort[l-1]
      end
    else for l:=1 to wortlaenge do feld[l,zl]:=wort[l];
    worduebergabe((9-zl),false)
  end;

procedure neunzehn(waag:byte);
  begin
    suchewort(feld[waag,1],feld[waag,2],feld[waag,3],
              feld[waag,4],feld[waag,5],5);
    if wort='' then begin
      suchewort(feld[waag,1],feld[waag,2],feld[waag,3],feld[waag,4],' ',4);
      if wort='' then begin
        suchewort(feld[waag,1],feld[waag,2],feld[waag,3],' ',' ',3);
        if wort='' then begin
          suchewort(feld[waag,1],feld[waag,2],' ',' ',' ',2);
          if wort<>'' then worduebergabe((waag+5),true)
          end
        else worduebergabe((waag+5),true)
        end
      else worduebergabe((waag+5),true)
      end
     else worduebergabe((waag+5),true)
  end;

  begin   {Hauptteil von einsetzen}
    p:=0;
    o:=0;
    l:=0;
    repeat
      inc(p);
      for l:=1 to 5 do
        for m:= 1 to 5 do feld[l,m]:=' ';
      for l:=1 to 25 do begin
        eintrag[l].word:='';
        eintrag[l].waag:=false;
        eintrag[l].nr:=0
        end;
      eins;
      zwei;
      drei;
      vier;
      funf;
      o:=0;
      repeat
      m:=0;
      inc(o);
       repeat
       inc(m);
        repeat
          sechssiebenacht(1);  {8}
          if eintrag[8].word=#0#0 then begin
              repeat wort:=zuwort(3) until wortlaenge=2;
              for l:=4  to (wortlaenge+3) do feld[l,1]:=wort[l-3]
            end
        until (feld[5,1]<>#0);
        repeat
          sechssiebenacht(2); {7}
          if eintrag[7].word=#0#0 then begin
              repeat wort:=zuwort(3) until wortlaenge=2;
              for l:=4  to (wortlaenge+3) do feld[l,2]:=wort[l-3]
            end
         until (feld[5,2]<>#0);
        repeat
          sechssiebenacht(3); {6}
          if eintrag[6].word=#0#0 then begin
              repeat wort:=zuwort(3) until wortlaenge=2;
              for l:=4  to (wortlaenge+3) do feld[l,3]:=wort[l-3]
            end
         until (feld[5,3]<>#0);
        until ((feld[5,3]<>feld[5,2]) and (feld[5,3]<>feld[5,1]) and
              (feld[5,1]<>feld[5,2])) or (m=50) ;
        l:=0;
        repeat
          inc(l);
          neunzehn(4);
          neunzehn(5);
        until (l=4) or (eintrag[9].nr=9) or (eintrag[10].nr=10);
      until (o=3) or (eintrag[9].nr=9) or (eintrag[10].nr=10);
    until (p=2) or (eintrag[9].nr=9) or (eintrag[10].nr=10)
  end;

  procedure ausdr;
    const leerzeile='             ';
    type string18=string [18];
         feldt=array[1..5] of string18;
    var zeile: feldt;
    procedure zeilefuel;
    begin
      for l:=1 to 5 do begin
        zeile[l]:=' ';
        for m:=1 to 5 do begin
          zeile[l]:=zeile[l] + '  ' + feld[l,m]
        end
      end
    end;

    begin
      zeilefuel;
      r.assign (1,1,25,12);
      ausgbox[kreuznr]:= new (pdialog,init (r, char(kreuznr+49) + '.Rtsel'));
      with ausgbox[kreuznr]^ do
      begin
        r.assign (2,2,18,3);
        insert (new (pstatictext,init (r,zeile[1])));
        r.assign (2,3,18,4);
        insert (new (pstatictext,init (r,zeile[2])));
        r.assign (2,4,18,5);
        insert (new (pstatictext,init (r,zeile[3])));
        r.assign (2,5,18,6);
        insert (new (pstatictext,init (r,zeile[4])));
        r.assign (2,6,18,7);
        insert (new (pstatictext,init (r,zeile[5])));
        r.assign (1,8,14,10);
        insert (new (pbutton,init (r,'~S~peichern',cmyes,bfnormal)));
        r.assign (15,8,22,10);
        insert (new (pbutton,init (r,'~W~eg',cmcancel,bfnormal)))
      end;
      desktop^.insert (ausgbox[kreuznr]);
      if desktop^.execview(ausgbox[kreuznr]) = cmyes then begin
         uebergab;
         inc(kreuznr)
        end
      else
         dispose(ausgbox[kreuznr],done)
      end;

begin  {Hauptteil von kreuz}
  sound(2000);delay(100);nosound;
  r.assign (15,8,61,13);
  wartbox:= new (pdialog,init (r,'Achtung!'));
  r.assign (1,1,45,4);
  wartbox^.insert (new (pstatictext,init (r,
     ' Einen  Moment, bitte!  Es wird  gerechnet.' + chr(13) +
     ' Machen  Sie  ruhig eine  kleine Pause und ' + chr(13) +
     ' lehnen sich zurck! Ich melde mich gleich.'
     )));
  desktop^.insert (wartbox);
  oeffnen;
  einsetzen;
  dispose(wartbox,done);
  sound(2000);delay(100);nosound;
  ausdr
end;
{--------------------------------------------------------------------}
{Hier soll wie o.g. ein Rtsel bearbeitet werden}
{--------------------------------------------------------------------}
  procedure krapp.kreuzbearbeiten;
    begin
    end;
{--------------------------------------------------------------------}
{Hier wird der Desktop von allen Kreuzwortrtselfenstern beseitigt}
{--------------------------------------------------------------------}

  procedure krapp.fensterweg;
  begin
    for l:=(kreuznr-1) downto 0 do desktop^.delete(ausgbox[l]);
    kreuznr:=1
  end;
{--------------------------------------------------------------------}
{Das ist die Anfangsbox zur Information}
{--------------------------------------------------------------------}

  procedure krapp.info;

   type string48 = string [48];
        infotextarr=array [1..12] of string48;

   const
    infotext: infotextarr=
    (('                   Hallo!'),
     (' Kreuz ist ein Programm, mit dem Kreuzwortrtsel'),
     ('               erzeugt  werden   knnen.  Es ist'),
     ('               immer ein  Rtsel der Gre  5x5.'),
     ('               Es  knnte   Sprachlehrern   dazu'),
     ('               dienen, Vokabeln  kurz zu wieder-'),
     ('               holen.  Aber auch  Schler sollen'),
     ('               es nutzen, entweder  mit Freunden'),
     ('               oder  im  Unterricht.  Viel  Spa'),
     (' wnsche ich hierbei allen Rtselfreunden.'),
     (''),
     ('                             Torsten Schulz'));

   var
    c:word;
    r:trect;
    b:pdialog;
    a:pstatictext;
    begin
      r.assign (15,4,66,18);
      new (b,init (r,'Info ber Kreuz'));
      for l:=1 to 12 do begin
        r.assign (1,l,49,l+1);
        b^.insert (new (pstatictext, init (r, infotext[l])))
        end;
      r.assign (1,4,15,10);
      b^.insert (new (pbutton,init (r, '~O~k',cmok,bfdefault)));
      c:= desktop^.execview (b);
      dispose (b,done)
    end;
{--------------------------------------------------------------------}
{Das ist eine Tafel zur Erklrung der Bedienung}
{--------------------------------------------------------------------}

  procedure krapp.help;
   type string78 = string [78];
        infotextarr=array [1..19] of string78;
   const
    infotext: infotextarr=(
('Die Bedienung von "Kreuz" ist sehr einfach. Sie haben verschiedene Mglich-'),
('keiten ein Kreuzwortrtsel zu erzeugen:'),
('- Sie mssen immer eine Datei laden! Das erreichen Sie, indem Sie erst'),
('  "Datei" und dann "Datei laden" whlen. Dann erscheinen mehrere Dateien.'),
('  Whlen Sie eine!'),
('- Sie knnen aber auch eine eigene erzeugen und whlen diese dann aus wie'),
('  o.g. Eine eigene Datei erzeugen Sie, indem sie erst "Datei" und dann'),
('  "Datei erzeugen" whlen. Dann werden Sie gefragt, wie ihre Datei heien'),
('  soll. Hier whlen Sie eine Textdatei des Formats ASCII. Sie knnen diese'),
('  mit jedem Textverarbeitungssystem erstellen.'),
('- Jetzt knnen Sie ein Kreuzwortrtsel erstellen, indem Sie "Kreuzwort-'),
('  rtsel" und "Kreuzwortrtsel erzeugen" whlen. Bevor Sie ein weiteres'),
('  erzeugen knnen, mssen sie es speichern ("speichern") oder abrumen'),
('  ("weg"). Sie knnen die Rtsel beliebig verschieben.'),
(''),
(''),
(''),
(''),
('')
);


   var
    c:word;
    r:trect;
    b:pdialog;
    a:pstatictext;

    begin
      r.assign (0,0,80,23);
      new (b,init (r,'Hilfe! Hilfe!'));
      r.assign (1,21,79,23);
      b^.insert (new (pbutton,init (r, '~O~k',cmok,bfdefault)));
      for l:=1 to 19 do begin
        r.assign (2,l,79,l+1);
        b^.insert (new (pstatictext, init (r, infotext[l])))
        end;
      c:= desktop^.execview (b);
      dispose (b,done)
    end;

{---------------------------------------------------------------------}
{Die Ereignisdefinition dient der Programmsteuerung}
{---------------------------------------------------------------------}
procedure krapp.handleevent;

  begin
  tapplication.handleevent (event);
  case event.what of
    evcommand: begin
      case event.command of
        cmdaterzeugen: daterzeugen;
        cmdatladen: datladen;
        cmdatbearbeiten: datbearbeiten;
        cmkreuz: kreuz;
        cmkreuzbearbeiten: kreuzbearbeiten;
        cminfo: info;
        cmhelp: help;
        cmallefenstweg: fensterweg;
        else Exit
      end;
      clearevent (event)
    end
  end
end;

{--------------------------------------------------------------------}
{Hier ist festgelegt, da nur 6 Rtsel auf dem Bildschirm erscheinen}
{--------------------------------------------------------------------}

procedure krapp.idle;
  begin
    if (dateiname='') or (kreuznr > 5)
      then disablecommands ([cmkreuz])
      else  enablecommands ([cmkreuz])
  end;

{--------------------------------------------------------------------}
{Das ist das Hauptprogramm}
{--------------------------------------------------------------------}

var kreuzapp: krapp;

begin
  with kreuzapp do
  begin
    init;
    run;
    done
  end
end.
